@extends('backoffice.dashboard')

@section('content')

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())

<div class="container">
    <section class="add-listing-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <form method="POST" action="{{ route('guides.store') }}">
                        @csrf
                        <input type="hidden" name="id_type" value="{{ $type->id_type }}">

                        <div class="block-card mb-4">
                            <div class="block-card-header">
                                <h2 class="widget-title">إضافة دليل لنوع : {{ $type->type_ar }}</h2>
                                <div class="stroke-shape"></div>
                            </div>

                            <div class="block-card-body">

                                <div class="form-group">
                                    <label>العنوان بالعربية<span class="text-danger">*</span></label>
                                    <input type="text" name="titre_G" class="form-control" value="{{ old('titre_G') }}" required>
                                </div>

                                <div class="form-group">
                                    <label>العنوان بالفرنسية<span class="text-danger">*</span></label>
                                    <input type="text" name="titre_G" class="form-control" value="{{ old('titre_G') }}" required>
                                </div>

                                <div class="form-group">
                                    <label>العنوان بالانقليزية<span class="text-danger">*</span></label>
                                    <input type="text" name="titre_G" class="form-control" value="{{ old('titre_G') }}" required>
                                </div>

                                <div class="form-group">
                                    <label>نوع الدليل <span class="text-danger">*</span></label>
                                    <select id="type" name="type" class="form-control" required>
                                        <option value="" disabled selected>اختر...</option>
                                        <option value="menu_principal" {{ old('type') == 'menu_principal' ? 'selected' : '' }}>قائمة رئيسية</option>
                                        <option value="sous_menu" {{ old('type') == 'sous_menu' ? 'selected' : '' }}>قائمة فرعية</option>
                                    </select>
                                </div>

                                <div id="menuPrincipalSection" style="display: none;">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>الترتيب <span class="text-danger">*</span></label>
                                                <input type="number" name="ordre" class="form-control" value="{{ old('ordre', 1) }}">
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>نوع المحتوى <span class="text-danger">*</span></label>
                                                <select id="type_contenu" name="type_contenu" class="form-control">
                                                    <option value="" disabled selected>اختر...</option>
                                                    <option value="none" {{ old('type_contenu') == 'none' ? 'selected' : '' }}>بدون محتوى (قائمة رئيسية)</option>
                                                    <option value="lien" {{ old('type_contenu') == 'lien' ? 'selected' : '' }}>رابط خارجي</option>
                                                    <option value="builder" {{ old('type_contenu') == 'builder' ? 'selected' : '' }}>صفحة داخلية (منشئ الصفحات)</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div id="builderSection" class="form-group mt-3" style="display: none;">
                                        <label>اختيار الصفحة الداخلية (Builder)</label>
                                        <select name="builder_id" class="form-control">
                                            <option value="" selected disabled>اختر صفحة...</option>
                                        </select>
                                    </div>
                                </div>

                                <div id="sousMenuSection" style="display: none;">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>الترتيب <span class="text-danger">*</span></label>
                                                <input type="number" name="ordre" class="form-control" value="{{ old('ordre', 1) }}">
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>الدليل الأب (اختياري)</label>
                                                <select name="id_parent" class="form-control">
                                                    <option value="" selected disabled>اختر الدليل الأب...</option>
                                                    @foreach ($parentGuides as $guide)
                                                        <option value="{{ $guide['id_G'] }}" {{ old('id_parent') == $guide['id_G'] ? 'selected' : '' }}>
                                                            {{ $guide['titre_G'] }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                                                
                                
                            </div>

                            <div class="block-card-footer mt-3 mb-3 text-center">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
                                    <i class="la la-save mr-1"></i> حفظ
                                </button>
                                <a href="{{ route('guides.index', ['tp' => $type->id_type]) }}" class="btn bg-rgb-primary1 font-weight-medium">
                                    <i class="la la-times mr-1"></i> إلغاء
                                </a>

                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </section>
</div>

<!--script>
    document.addEventListener('DOMContentLoaded', function() {
        const selectType = document.getElementById('type_contenu');
        const builderSection = document.getElementById('builderSection');

        function toggleBuilderSection() {
            if (selectType.value === 'builder') {
                builderSection.style.display = 'block';
            } else {
                builderSection.style.display = 'none';
            }
        }
        selectType.addEventListener('change', toggleBuilderSection);
        toggleBuilderSection();
    });
</!--script-->


<script>
    document.addEventListener('DOMContentLoaded', function() {
        const selectType = document.getElementById('type');
        const menuPrincipalSection = document.getElementById('menuPrincipalSection');
        const sousMenuSection = document.getElementById('sousMenuSection');
        const typeContenuSelect = document.getElementById('type_contenu');
        const builderSection = document.getElementById('builderSection');

        function toggleSections() {
            const type = selectType.value;
            menuPrincipalSection.style.display = (type === 'menu_principal') ? 'block' : 'none';
            sousMenuSection.style.display = (type === 'sous_menu') ? 'block' : 'none';
        }

        function toggleBuilderSection() {
            if (typeContenuSelect && typeContenuSelect.value === 'builder') {
                builderSection.style.display = 'block';
            } else {
                builderSection.style.display = 'none';
            }
        }

        if (selectType) selectType.addEventListener('change', toggleSections);
        if (typeContenuSelect) typeContenuSelect.addEventListener('change', toggleBuilderSection);

        toggleSections();
        toggleBuilderSection();
    });
</script>

@else
<script>
    window.location.href = "{{ route('admin') }}";
</script>
@endif

@endsection
